import { BatchAction, TBDialog } from 'TB';

export default class HelloSelected extends BatchAction {
    constructor() {
        super({
            group: 'AAA-addToInfo',
            order: 0,
            labels: {
                en: 'Hello Selected',
            },
            iconClass: 'far fa-wave',
        });
    }

    isSuitable(nodes, context, readOnly) {
        return nodes.every((node) => node.uri);
    }

    run(nodes, context, postAction) {
        //add all nodes to the asset list

        let selected = nodes.map((n) => {
            return <li key={`${n.uri}_info_dialog`}>{n.label}</li>;
        });

        let message = <ul>{selected}</ul>;

        context.showDialog(<TBDialog title="Hello Selected" body={message} enableOkButton={true} />);
    }
}
