import React from 'react';
import { AppContext, Settings, Panel, BooleanSetting, PanelType } from 'TB';

export default class HelloPanel extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            showDate: HelloPanel.showDateSetting.isTrue(),
        };
    }

    componentDidMount() {
        this.showCreatorKey = Settings.addListener(HelloPanel.showDateSetting.name, () => {
            this.setState({
                showDate: HelloPanel.showDateSetting.isTrue(),
            });
        });
    }

    render() {
        return (
            <Panel
                {...this.props}
                body={this.renderBody()}
                className="HelloWorldPanel"
                panel={this}
                panelId={this.props.panelId}
                title="Hello World"
            />
        );
    }

    renderBody = () => {
        return (
            <React.Fragment>
                <h1>Hello World</h1>
                { this.state.showDate ? (<span>{new Date().toString()}</span>) : null  }
            </React.Fragment>
        );
    };
}

HelloPanel.contextType = AppContext;

HelloPanel.showDateSetting = new BooleanSetting({
    name: 'HelloPanel-showDate',
    labels: {
        en: 'Show Current Date',
    },
});

HelloPanel.panelType = new PanelType({
    name: 'HelloPanel',
    labels: {
        en: 'Hello World',
    },
    group: PanelType.ReportsGroup,
    iconClass: 'fas fa-newspaper',
    order: 0,
    settings: [HelloPanel.showDateSetting],
});
